//*************************************************************************************************
window.onload = function(){
//*************************************************************************************************
	try{
		// load resource
		fncLoadResource();

		var isReturnIndex = fncIsNonwordSearch();
		if(isReturnIndex){
			window.open("../index.html", "_self");
		}

		var iHideLevel = 999;
		var bIsCurrentChapter = false;

		// ----------------------------------------------------------------------------------------
		// Search
		// ----------------------------------------------------------------------------------------
		// set click event handler to search button
		document.getElementById("id_search_button").onclick = function() {
			var strSearchText = document.getElementById("id_search").value;
			if ((strSearchText == fncGetResourceByResourceId("enter_search_keyword")) ||
				(strSearchText == "")) {
				return false;
			}
			strSearchHelpTocId = "../search/search";
			fncOpenSearchPage(1, false);
			return false;
		}
		if(document.getElementById("id_search_button_sub") != null){
			document.getElementById("id_search_button_sub").onclick = function() {
				var strSearchText = document.getElementById("id_search_sub").value;
				if ((strSearchText == fncGetResourceByResourceId("enter_search_keyword")) ||
					(strSearchText == "")) {
					return false;
				}
				strSearchHelpTocId = "../search/search";
				fncOpenSearchPage(1, true);
				return false;
			}
		}

		var strSearchText = document.location.search.split("?search=")[1];
		if ((strSearchText != undefined) || ((document.location.search == "") && (document.location.toString().indexOf("search.html") != -1))) {
			if((document.location.search == "") && (document.location.toString().indexOf("search.html") != -1)){
				strSearchText = "";
			}
			strSearchText = decodeURIComponent(strSearchText);
			document.getElementById("id_search").value = strSearchText;
			document.getElementById("id_search").style.color = "#000000";
			if(document.getElementById("id_search_button_sub") != null){
				document.getElementById("id_search_sub").value = strSearchText;
				document.getElementById("id_search_sub").style.color = "#000000";
			}

			fncSetCookie("SEARCH-RESULT-SETTING", "");
			fncDoSearch(1);
		}

		var strSavedSearchKeyword = fncGetCookie("SEARCH-KEYWORD");
		if (strSavedSearchKeyword) {
			document.getElementById("id_search").value = strSavedSearchKeyword;
		}
		fncSearchBox();

		// ----------------------------------------------------------------------------------------
		// highlight
		// ----------------------------------------------------------------------------------------
		if (document.location.search) {
			if (strWindowType != "HOME") {
				var ti = window.setTimeout("fncMarkupSearch()", 26);
			}
		} else {
			// for IE6
			if (document.all) { // TODO: ignore IE8
				if (document.location.hash != "") {
					var strHash = document.location.hash.substring(1);
					if (document.all.item(strHash)) {
						document.all.item(strHash).scrollIntoView(true);
					}
				}
			}
		}

		// ----------------------------------------------------------------------------------------
		// for IE7: scroll bar position and height
		// ----------------------------------------------------------------------------------------
		if (	(document.all) // ignore FF/SF
			&&	(window.XMLHttpRequest)	// ignore IE6
		) {
			var strContents = document.getElementById("id_content").innerHTML;
			document.getElementById("id_content").innerHTML = strContents.replace(/<hr>/gi, "<div style=\"height:40px;vertical-align:Middle;\"><hr /></div>");
		}
	}catch(e){
	}
}

function fncMarkupSearch() {
	try {

		// get search keyword
		var strSearchText = document.location.search.split("?search=")[1];

		strSearchText = strSearchText.split("&word=yes")[0];
		if (strSearchText != "") {

			// decode
			strSearchText = decodeURIComponent(strSearchText);

			// trim
			strSearchText = strSearchText.trim();

			if (strSearchText == fncGetResourceByResourceId("enter_search_keyword")) {
				return;
			}

			var res = / |　/;
			var arrSearchText = strSearchText.split(res);

			var iLoopLength = arrSearchText.length;
			for (var i = 0; i < iLoopLength; i++) {
				arrSearchText[i] = arrSearchText[i].replace(/___SPACE___/g, " ");
			}

			var strSearchOptionCaseSensitive = "i";
			if (fncGetCookie("SEARCH-OPTIONS-CASE") == "TRUE") {
				strSearchOptionCaseSensitive = "";
			}

			var bWordMarking = false;
			if (document.location.search.indexOf("&word=yes") != -1) {
				bWordMarking = true;
			}

			fncMarkupText(
				document.getElementById("id_content"),
				arrSearchText,
				strSearchOptionCaseSensitive,
				bWordMarking
			);
		}
	} catch (e) {
	}
}

// ------------------------------------------------------------------------------------------------
// highlight
// ------------------------------------------------------------------------------------------------
function fncMarkupText(element, arrSearchText, strSearchOptionCaseSensitive, bWordMarking) {
	try {

		var nElementChildLength = element.childNodes.length;
		for (var i = 0; i < nElementChildLength; i++) {
			var child = element.childNodes[i];

			if (child.nodeType == 3) { // #text
				var strNodeValue = child.nodeValue;

				var strNodeValueTemp = strNodeValue.replace(/\t| |\n/g, "");
				if (strNodeValueTemp == "") {
					continue;
				}

				var bIsMarkedup = false;

				var nMarkerColor = 0;
				var nSearchTextLength = arrSearchText.length;
				for (var j = 0; j < nSearchTextLength; j++) {

					switch (nMarkerColor) {
						case 0:
							strMarkerColor = String.fromCharCode(0x2080); // "₀";
							break;
						case 1:
							strMarkerColor = String.fromCharCode(0x2081); // "₁";
							break;
						case 2:
							strMarkerColor = String.fromCharCode(0x2082); // "₂";
							break;
						case 3:
							strMarkerColor = String.fromCharCode(0x2083); // "₃";
							break;
						case 4:
							strMarkerColor = String.fromCharCode(0x2084); // "₄";
							break;
						case 5:
							strMarkerColor = String.fromCharCode(0x2085); // "₅";
							break;
						case 6:
							strMarkerColor = String.fromCharCode(0x2086); // "₆";
							break;
						case 7:
							strMarkerColor = String.fromCharCode(0x2087); // "₇";
							break;
						case 8:
							strMarkerColor = String.fromCharCode(0x2088); // "₈";
							break;
						case 9:
							strMarkerColor = String.fromCharCode(0x2089); // "₉";
							break;
					}

					var strSearchText = arrSearchText[j];

					var strSearchTextParam = "(" + strSearchText + ")";
					if (bWordMarking) {
						strSearchTextParam = "\\b(" + strSearchText + ")\\b";
					}
					var re = new RegExp(strSearchTextParam, "g" + strSearchOptionCaseSensitive);
					if (re.exec(strNodeValue) != null) {
						var strNodeValue = strNodeValue.replace(re, String.fromCharCode(0x2045) + strMarkerColor + String.fromCharCode(0x2046) + "$1" + String.fromCharCode(0x208E));
						bIsMarkedup = true;
					}
					nMarkerColor++;
					if (nMarkerColor >= 10) {
						nMarkerColor = 0;
					}
				}
				if (bIsMarkedup) {
					strNodeValue = strNodeValue.replace(/</g, "&lt;");
					strNodeValue = strNodeValue.replace(/>/g, "&gt;");

					strNodeValue = strNodeValue.replace(/\u2045/g, "<span id=\"id_hit\" class=\"hit hit_"); // ⁅

					strNodeValue = strNodeValue.replace(/\u2046/g, "\">"); // ⁆

					strNodeValue = strNodeValue.replace(/\u2080/g, "0"); // ₀
					strNodeValue = strNodeValue.replace(/\u2081/g, "1"); // ₁

					strNodeValue = strNodeValue.replace(/\u2082/g, "2"); // ₂

					strNodeValue = strNodeValue.replace(/\u2083/g, "3"); // ₃

					strNodeValue = strNodeValue.replace(/\u2084/g, "4"); // ₄

					strNodeValue = strNodeValue.replace(/\u2085/g, "5"); // ₅

					strNodeValue = strNodeValue.replace(/\u2086/g, "6"); // ₆

					strNodeValue = strNodeValue.replace(/\u2087/g, "7"); // ₇

					strNodeValue = strNodeValue.replace(/\u2088/g, "8"); // ₈

					strNodeValue = strNodeValue.replace(/\u2089/g, "9"); // ₉

					strNodeValue = strNodeValue.replace(/\u208E/g, "</span>"); // ₎


					var newNode = document.createElement("span");
					newNode.innerHTML = strNodeValue;
					element.replaceChild(newNode, child);
				}
			} else {
				fncMarkupText(child, arrSearchText, strSearchOptionCaseSensitive, bWordMarking);
			}
		}
	} catch (e) {
	}
}

var strWindowType = "MAIN";

function fncOpenSearchPage(nPage, isSub) {
	try {
		var strFilePath = "";
		var htmlHref = document.location.href;
		var posContents = htmlHref.indexOf("/contents/");
		var posCover = htmlHref.indexOf("/cover/");
		var posSearch = htmlHref.indexOf("/search/");
		var search_texts = "";
		if(isSub == false){
			search_texts = encodeURIComponent(document.getElementById("id_search").value);
		}else{
			search_texts = encodeURIComponent(document.getElementById("id_search_sub").value);
		}

		if((posContents != -1) || (posCover != -1) || (posSearch != -1)){
			strFilePath = "../search/search.html?search=" + search_texts;
		}else{
			strFilePath = "./search/search.html?search=" + search_texts;
		}

		fncSetSearchResultsInfo(nPage);
		window.open(strFilePath, "_self");
	} catch (e) {
	}
}

function fncIsNonwordSearch() {
	try{
		var htmlHref = document.location.href;
		var strSearchText = document.location.search.split("?search=")[1];
		if ((strSearchText == undefined) && (htmlHref.indexOf("search.html") != -1)) {
			return true;
		}else{
			return false;
		}
	}catch(e){
	}
}
